/* 
 * lseek.c 
 *
 * Створює файл заданого розміру (який автоматично заповнюється нулями).
 * Ілюструє порядок оперування покажчиком поточної позиції у файлів
 * (за допомогою функції lseek()).
 *
 */

#include <fcntl.h>
#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>


int main(int argc, char *argv[])
{
        int zero = 0;
        char *filename;
        size_t size;
        int fd;

        /* Аналізує аргументи. */
        if (argc != 3) {
                fprintf(stderr, "Usage: %s filename size\n",
                                                basename(argv[0]));
                exit(EXIT_FAILURE);
        }
        filename = argv[1];
        size = (size_t) atoi(argv[2]);

        /* Створює новий файл. */
        fd = open(filename, O_WRONLY | O_CREAT | O_EXCL, 0666);
        if (fd < 0) {
                perror("open()");
                exit(EXIT_FAILURE);
        }

        /* Пересуває покажчик поточної позиції в точку size - 1. */
        if (lseek(fd, size - 1, SEEK_SET) < 0) {
                perror("lseek()");
                exit(EXIT_FAILURE);
        }

        /* Записує в файл нульовий байт. */
        if (write(fd, &zero, 1) < 0) {
                perror("write()");
                exit(EXIT_FAILURE);
        }

        /* Закриває файл. */
        if (close(fd) != 0) {
                perror("close()");
                exit(EXIT_FAILURE);
        }
        /* Завершує роботу. */
        exit(EXIT_SUCCESS);
}
